from alembic import op
import sqlalchemy as sa


def upgrade_enum(name: str, values: list[str], columns: list[tuple[str, str]]):
    """
    Самый понятный на данный момент способ менять Enum:
      - переименовать старый Enum
      - создать новый Enum
      - поменять у колонки старый Enum на новый
      - удалить старый
    :param name: название Enum в Postgres
    :param values: новые значения Enum
    :param columns: пара (таблица, колонка), которая соотвествует Enum, которое нам надо поменять
    :return:
    """
    tmp_name = 'tmp_' + name
    op.execute(f'ALTER TYPE {name} RENAME TO {tmp_name}')

    new_type = sa.Enum(*values, name=name)
    new_type.create(op.get_bind())

    for table, column in columns:
        op.execute(
            f'ALTER TABLE {table} ALTER COLUMN {column} TYPE {name} USING {column}::text::{name}'
        )
    op.execute(f'DROP TYPE {tmp_name}')
