"""transfer_tables

Revision ID: 0001
Revises:
Create Date: 2021-07-12 12:20:25.057712+00:00

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '0001'
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('intranet_staff',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('chief_id', sa.Integer(), nullable=True),
    sa.Column('user_id', sa.Integer(), nullable=True),
    sa.Column('login', sa.String(), nullable=True),
    sa.Column('uid', sa.Integer(), nullable=True),
    sa.Column('first_name', sa.String(), nullable=True),
    sa.Column('first_name_en', sa.String(), nullable=True),
    sa.Column('last_name', sa.String(), nullable=True),
    sa.Column('last_name_en', sa.String(), nullable=True),
    sa.Column('is_robot', sa.Boolean(), nullable=True),
    sa.Column('affiliation', sa.Enum('yandex', 'yamoney', 'external', name='staffaffilation'), nullable=True),
    sa.Column('gender', sa.Enum('M', 'F', name='staffgender'), nullable=True),
    sa.Column('is_dismissed', sa.Boolean(), nullable=True),
    sa.Column('join_at', sa.DateTime(), nullable=True),
    sa.Column('quit_at', sa.DateTime(), nullable=True),
    sa.Column('lang_ui', sa.Enum('eu', 'ru', 'tr', name='stafflang'), nullable=True),
    sa.Column('work_email', sa.String(), nullable=True),
    sa.Column('telegram_account', sa.String(), nullable=True),
    sa.Column('staff_id', sa.Integer(), nullable=True),
    sa.Column('created_at', sa.DateTime(), nullable=True),
    sa.Column('modified_at', sa.DateTime(), nullable=True),
    sa.ForeignKeyConstraint(['chief_id'], ['intranet_staff.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_intranet_staff_affiliation'), 'intranet_staff', ['affiliation'], unique=False)
    #op.create_index(op.f('ix_intranet_staff_department'), 'intranet_staff', ['department'], unique=False)
    op.create_index(op.f('ix_intranet_staff_first_name'), 'intranet_staff', ['first_name'], unique=False)
    op.create_index(op.f('ix_intranet_staff_first_name_en'), 'intranet_staff', ['first_name_en'], unique=False)
    op.create_index(op.f('ix_intranet_staff_gender'), 'intranet_staff', ['gender'], unique=False)
    op.create_index(op.f('ix_intranet_staff_id'), 'intranet_staff', ['id'], unique=False)
    op.create_index(op.f('ix_intranet_staff_lang_ui'), 'intranet_staff', ['lang_ui'], unique=False)
    op.create_index(op.f('ix_intranet_staff_last_name'), 'intranet_staff', ['last_name'], unique=False)
    op.create_index(op.f('ix_intranet_staff_last_name_en'), 'intranet_staff', ['last_name_en'], unique=False)
    op.create_index(op.f('ix_intranet_staff_login'), 'intranet_staff', ['login'], unique=False)
    op.create_index(op.f('ix_intranet_staff_staff_id'), 'intranet_staff', ['staff_id'], unique=False)
    op.create_index(op.f('ix_intranet_staff_uid'), 'intranet_staff', ['uid'], unique=True)
    op.create_index(op.f('ix_intranet_staff_user_id'), 'intranet_staff', ['user_id'], unique=False)
    op.create_index(op.f('ix_intranet_staff_work_email'), 'intranet_staff', ['work_email'], unique=False)
    op.create_table('services_service',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('parent_id', sa.Integer(), nullable=True),
    sa.Column('owner_id', sa.Integer(), nullable=True),
    sa.Column('level', sa.Integer(), nullable=True),
    sa.Column('state', sa.Enum('develop', 'supported', 'needinfo', 'closed', 'deleted', 'ALL_STATES',
                               'ALIVE_STATES', 'ACTIVE_STATES', 'NORMAL_STATES', name='servicestate'),
              nullable=True),
    sa.Column('name', sa.String(), nullable=True),
    sa.Column('name_en', sa.String(), nullable=True),
    sa.Column('slug', sa.String(), nullable=False),
    sa.Column('description', sa.String(), nullable=True),
    sa.Column('description_en', sa.String(), nullable=True),
    sa.Column('is_base', sa.Boolean(), nullable=True),
    sa.Column('readonly_state', sa.Enum('creating', 'moving', 'renaming', 'deleting', 'closing',
                                        name='servicereadonlystatus'), nullable=True),
    sa.Column('readonly_start_time', sa.DateTime(), nullable=True),
    sa.Column('staff_id', sa.Integer(), nullable=True),
    sa.Column('path', sa.String(), nullable=True),
    sa.Column('ancestors', sa.JSON(), nullable=True),
    sa.Column('is_exportable', sa.Boolean(), nullable=True),
    sa.Column('created_at', sa.DateTime(), nullable=True),
    sa.Column('modified_at', sa.DateTime(), nullable=True),
    sa.ForeignKeyConstraint(['owner_id'], ['intranet_staff.id'], ),
    sa.ForeignKeyConstraint(['parent_id'], ['services_service.id'], ),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('slug')
    )
    op.create_index(op.f('ix_services_service_id'), 'services_service', ['id'], unique=False)
    op.create_index(op.f('ix_services_service_level'), 'services_service', ['level'], unique=False)
    op.create_index(op.f('ix_services_service_staff_id'), 'services_service', ['staff_id'], unique=False)
    op.create_index(op.f('ix_services_service_state'), 'services_service', ['state'], unique=False)
    op.create_table('roles_rolescope',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('slug', sa.String(), nullable=True),
    sa.Column('name', sa.String(), nullable=True),
    sa.Column('name_en', sa.String(), nullable=True),
    sa.Column('protected', sa.Boolean(), nullable=True),
    sa.Column('can_issue_at_duty_time', sa.Boolean(), nullable=True),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('slug')
    )
    op.create_index(op.f('ix_roles_rolescope_id'), 'roles_rolescope', ['id'], unique=False)
    op.create_table('duty_gap',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('staff_id', sa.Integer(), nullable=True),
    sa.Column('status', sa.Enum('active', 'deleted', name='gapstatus'), nullable=False),
    sa.Column('work_in_absence', sa.Boolean(), nullable=True),
    sa.Column('full_day', sa.Boolean(), nullable=True),
    sa.Column('type', sa.String(), nullable=True),
    sa.Column('created_at', sa.DateTime(timezone=True), nullable=False),
    sa.Column('deleted_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('start', sa.DateTime(timezone=True), nullable=True),
    sa.Column('end', sa.DateTime(timezone=True), nullable=True),
    sa.Column('gap_id', sa.BigInteger(), nullable=True),
    sa.ForeignKeyConstraint(['staff_id'], ['intranet_staff.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_duty_gap_gap_id'), 'duty_gap', ['gap_id'], unique=True)
    op.create_index(op.f('ix_duty_gap_id'), 'duty_gap', ['id'], unique=False)
    op.create_table('roles_role',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.String(), nullable=True),
    sa.Column('name_en', sa.String(), nullable=True),
    sa.Column('code', sa.String(), nullable=True),
    sa.Column('created_at', sa.DateTime(), nullable=True),
    sa.Column('modified_at', sa.DateTime(), nullable=True),
    sa.Column('is_exportable', sa.Boolean(), nullable=True),
    sa.Column('projected_role_id', sa.Integer(), nullable=True),
    sa.Column('service_id', sa.Integer(), nullable=True),
    sa.Column('scope_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['projected_role_id'], ['roles_role.id'], ),
    sa.ForeignKeyConstraint(['scope_id'], ['roles_rolescope.id'], ),
    sa.ForeignKeyConstraint(['service_id'], ['services_service.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_roles_role_code'), 'roles_role', ['code'], unique=False)
    op.create_index(op.f('ix_roles_role_id'), 'roles_role', ['id'], unique=False)
    op.create_index(op.f('ix_roles_role_name'), 'roles_role', ['name'], unique=False)
    op.create_index(op.f('ix_roles_role_name_en'), 'roles_role', ['name_en'], unique=False)
    op.create_table('services_servicemember',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('staff_id', sa.Integer(), nullable=True),
    sa.Column('service_id', sa.Integer(), nullable=True),
    sa.Column('role_id', sa.Integer(), nullable=True),
    sa.Column('state', sa.Enum('requested', 'active', 'depriving', 'deprived', name='memberstatus'), nullable=False),
    sa.Column('autorequested', sa.Boolean(), nullable=True),
    sa.Column('custom_role', sa.String(), nullable=True),
    sa.Column('position', sa.Integer(), nullable=True),
    sa.Column('is_temp', sa.Boolean(), nullable=True),
    sa.Column('created_at', sa.DateTime(), nullable=True),
    sa.Column('modified_at', sa.DateTime(), nullable=True),
    sa.Column('found_in_staff_at', sa.DateTime(), nullable=True),
    sa.Column('from_department_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['role_id'], ['roles_role.id'], ),
    sa.ForeignKeyConstraint(['service_id'], ['services_service.id'], ),
    sa.ForeignKeyConstraint(['staff_id'], ['intranet_staff.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_services_servicemember_found_in_staff_at'), 'services_servicemember', ['found_in_staff_at'], unique=False)
    op.create_index(op.f('ix_services_servicemember_id'), 'services_servicemember', ['id'], unique=False)
    op.create_index(op.f('ix_services_servicemember_position'), 'services_servicemember', ['position'], unique=False)

    op.create_table('holidays_holiday',
    sa.Column('date', sa.Date(), nullable=False),
    sa.PrimaryKeyConstraint('date')
    )
    op.create_table('auth_user_user_permissions',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('user_id', sa.Integer(), nullable=True),
    sa.Column('permission_id', sa.Integer(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_auth_user_user_permissions_id'), 'auth_user_user_permissions', ['id'], unique=False)
    op.create_index(op.f('ix_auth_user_user_permissions_permission_id'), 'auth_user_user_permissions', ['permission_id'], unique=False)
    op.create_index(op.f('ix_auth_user_user_permissions_user_id'), 'auth_user_user_permissions', ['user_id'], unique=False)

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f('ix_services_servicemember_position'), table_name='services_servicemember')
    op.drop_index(op.f('ix_services_servicemember_id'), table_name='services_servicemember')
    op.drop_index(op.f('ix_services_servicemember_found_in_staff_at'), table_name='services_servicemember')
    op.drop_table('services_servicemember')
    op.drop_index(op.f('ix_services_service_state'), table_name='services_service')
    op.drop_index(op.f('ix_services_service_staff_id'), table_name='services_service')
    op.drop_index(op.f('ix_services_service_level'), table_name='services_service')
    op.drop_index(op.f('ix_services_service_id'), table_name='services_service')
    op.drop_table('services_service')
    op.drop_index(op.f('ix_roles_role_position'), table_name='roles_role')
    op.drop_index(op.f('ix_roles_role_name_en'), table_name='roles_role')
    op.drop_index(op.f('ix_roles_role_name'), table_name='roles_role')
    op.drop_index(op.f('ix_roles_role_id'), table_name='roles_role')
    op.drop_index(op.f('ix_roles_role_code'), table_name='roles_role')
    op.drop_table('roles_role')
    op.drop_index(op.f('ix_duty_gap_id'), table_name='duty_gap')
    op.drop_index(op.f('ix_duty_gap_gap_id'), table_name='duty_gap')
    op.drop_table('duty_gap')
    op.drop_index(op.f('ix_roles_rolescope_id'), table_name='roles_rolescope')
    op.drop_table('roles_rolescope')
    op.drop_index(op.f('ix_intranet_staff_work_email'), table_name='intranet_staff')
    op.drop_index(op.f('ix_intranet_staff_user_id'), table_name='intranet_staff')
    op.drop_index(op.f('ix_intranet_staff_uid'), table_name='intranet_staff')
    op.drop_index(op.f('ix_intranet_staff_staff_id'), table_name='intranet_staff')
    op.drop_index(op.f('ix_intranet_staff_login'), table_name='intranet_staff')
    op.drop_index(op.f('ix_intranet_staff_last_name_en'), table_name='intranet_staff')
    op.drop_index(op.f('ix_intranet_staff_last_name'), table_name='intranet_staff')
    op.drop_index(op.f('ix_intranet_staff_lang_ui'), table_name='intranet_staff')
    op.drop_index(op.f('ix_intranet_staff_id'), table_name='intranet_staff')
    op.drop_index(op.f('ix_intranet_staff_gender'), table_name='intranet_staff')
    op.drop_index(op.f('ix_intranet_staff_first_name_en'), table_name='intranet_staff')
    op.drop_index(op.f('ix_intranet_staff_first_name'), table_name='intranet_staff')
    op.drop_index(op.f('ix_intranet_staff_department'), table_name='intranet_staff')
    op.drop_index(op.f('ix_intranet_staff_affiliation'), table_name='intranet_staff')
    op.drop_table('intranet_staff')
    op.drop_table('holidays_holiday')
    op.drop_index(op.f('ix_auth_user_user_permissions_user_id'), table_name='auth_user_user_permissions')
    op.drop_index(op.f('ix_auth_user_user_permissions_permission_id'), table_name='auth_user_user_permissions')
    op.drop_index(op.f('ix_auth_user_user_permissions_id'), table_name='auth_user_user_permissions')
    op.drop_table('auth_user_user_permissions')
    # ### end Alembic commands ###
