"""initial

Revision ID: 0002
Revises: 0001
Create Date: 2021-07-12 13:47:08.034049+00:00

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '0002'
down_revision = '0001'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('schedules_group',
    sa.Column('created_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('updated_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('slug', sa.String(), nullable=False),
    sa.Column('name', sa.String(), nullable=False),
    sa.Column('people_allocation_error', sa.JSON(), nullable=True),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('slug')
    )
    op.create_index(op.f('ix_schedules_group_id'), 'schedules_group', ['id'], unique=False)
    op.create_table('composition',
    sa.Column('created_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('updated_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('composition_type', sa.Enum('empty', 'role', 'scope', 'service', name='compositiontype'), nullable=False),
    sa.Column('role_id', sa.Integer(), nullable=True),
    sa.Column('scope_id', sa.Integer(), nullable=True),
    sa.Column('service_id', sa.Integer(), nullable=True),
    sa.Column('autoupdate', sa.Boolean(), nullable=True),
    sa.ForeignKeyConstraint(['role_id'], ['roles_role.id'], ),
    sa.ForeignKeyConstraint(['scope_id'], ['roles_rolescope.id'], ),
    sa.ForeignKeyConstraint(['service_id'], ['services_service.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_composition_id'), 'composition', ['id'], unique=False)
    op.create_table('responsible',
    sa.Column('created_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('updated_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('type_responsible', sa.Enum('staff', 'role', 'service', name='responsibletype'), nullable=False),
    sa.Column('staff_id', sa.Integer(), nullable=True),
    sa.Column('role_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['role_id'], ['roles_role.id'], ),
    sa.ForeignKeyConstraint(['staff_id'], ['intranet_staff.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_responsible_id'), 'responsible', ['id'], unique=False)
    op.create_table('schedule',
    sa.Column('created_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('updated_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('slug', sa.String(), nullable=False),
    sa.Column('name', sa.String(), nullable=False),
    sa.Column('state', sa.Enum('active', 'disabled', name='schedulestate'), nullable=False),
    sa.Column('author_id', sa.Integer(), nullable=False),
    sa.Column('service_id', sa.Integer(), nullable=False),
    sa.Column('schedules_group_id', sa.Integer(), nullable=False),
    sa.Column('start', sa.DateTime(timezone=True), nullable=False),
    sa.Column('days_for_notify_of_problems', sa.Interval(), nullable=False),
    sa.Column('days_for_notify_of_begin', sa.ARRAY(sa.Interval()), nullable=False),
    sa.Column('length_of_absences', sa.Interval(), nullable=False),
    sa.Column('pin_shifts', sa.Interval(), nullable=False),
    sa.Column('recalculate', sa.Boolean(), nullable=True),
    sa.Column('deleted_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('deleted_by_id', sa.Integer(), nullable=True),
    sa.Column('shifts_boundary_recalculation_error', sa.JSON(), nullable=True),
    sa.Column('stopped_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('stopped_by_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['author_id'], ['intranet_staff.id'], ),
    sa.ForeignKeyConstraint(['deleted_by_id'], ['intranet_staff.id'], ),
    sa.ForeignKeyConstraint(['schedules_group_id'], ['schedules_group.id'], ),
    sa.ForeignKeyConstraint(['service_id'], ['services_service.id'], ),
    sa.ForeignKeyConstraint(['stopped_by_id'], ['intranet_staff.id'], ),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('service_id', 'slug', name='uniq_service_schedule')
    )
    op.create_index(op.f('ix_schedule_id'), 'schedule', ['id'], unique=False)
    op.create_table('composition_participants',
    sa.Column('created_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('updated_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('composition_id', sa.Integer(), nullable=False),
    sa.Column('staff_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['composition_id'], ['composition.id'], ),
    sa.ForeignKeyConstraint(['staff_id'], ['intranet_staff.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_composition_participants_id'), 'composition_participants', ['id'], unique=False)
    op.create_table('interval',
    sa.Column('created_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('updated_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('schedule_id', sa.Integer(), nullable=False),
    sa.Column('duration', sa.Interval(), nullable=False),
    sa.Column('type_employment', sa.Enum('full', 'empty', name='intervaltypeemployment'),
              nullable=False),
    sa.Column('unexpected_holidays', sa.Enum('remove', 'ignoring', name='intervalunexpectedholidays'),
              nullable=False),
    sa.Column('order', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['schedule_id'], ['schedule.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_interval_id'), 'interval', ['id'], unique=False)
    op.create_table('revision',
    sa.Column('created_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('updated_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('schedule_id', sa.Integer(), nullable=False),
    sa.Column('state', sa.Enum('new', 'active', 'disabled', name='revisionstate'), nullable=False),
    sa.ForeignKeyConstraint(['schedule_id'], ['schedule.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_revision_id'), 'revision', ['id'], unique=False)
    op.create_table('schedule_responsible',
    sa.Column('created_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('updated_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('schedule_id', sa.Integer(), nullable=True),
    sa.Column('responsible_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['responsible_id'], ['responsible.id'], ),
    sa.ForeignKeyConstraint(['schedule_id'], ['schedule.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('interval_revision',
    sa.Column('created_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('updated_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('revision_id', sa.Integer(), nullable=True),
    sa.Column('interval_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['interval_id'], ['interval.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['revision_id'], ['revision.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_interval_revision_id'), 'interval_revision', ['id'], unique=False)
    op.create_table('slot',
    sa.Column('created_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('updated_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('interval_id', sa.Integer(), nullable=False),
    sa.Column('role_on_duty_id', sa.Integer(), nullable=True),
    sa.Column('composition_id', sa.Integer(), nullable=True),
    sa.Column('show_in_staff', sa.Boolean(), nullable=True),
    sa.ForeignKeyConstraint(['composition_id'], ['composition.id'], ),
    sa.ForeignKeyConstraint(['interval_id'], ['interval.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['role_on_duty_id'], ['roles_role.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_slot_id'), 'slot', ['id'], unique=False)
    op.create_table('shift',
    sa.Column('created_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('updated_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('slot_id', sa.Integer(), nullable=False),
    sa.Column('start', sa.DateTime(timezone=True), nullable=False),
    sa.Column('end', sa.DateTime(timezone=True), nullable=False),
    sa.Column('status', sa.Enum('scheduled', 'active', 'disabled', name='shiftstate'), nullable=False),
    sa.Column('replacement_for_id', sa.Integer(), nullable=True),
    sa.Column('approved', sa.Boolean(), nullable=True),
    sa.Column('approved_by_id', sa.Integer(), nullable=True),
    sa.Column('approved_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('empty', sa.Boolean(), nullable=True),
    sa.ForeignKeyConstraint(['approved_by_id'], ['intranet_staff.id'], ),
    sa.ForeignKeyConstraint(['replacement_for_id'], ['shift.id'], ),
    sa.ForeignKeyConstraint(['slot_id'], ['slot.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_shift_id'), 'shift', ['id'], unique=False)
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f('ix_shift_id'), table_name='shift')
    op.drop_table('shift')
    op.drop_index(op.f('ix_slot_id'), table_name='slot')
    op.drop_table('slot')
    op.drop_index(op.f('ix_interval_revision_id'), table_name='interval_revision')
    op.drop_table('interval_revision')
    op.drop_table('schedule_responsible')
    op.drop_index(op.f('ix_revision_id'), table_name='revision')
    op.drop_table('revision')
    op.drop_index(op.f('ix_interval_id'), table_name='interval')
    op.drop_table('interval')
    op.drop_index(op.f('ix_composition_participants_id'), table_name='composition_participants')
    op.drop_table('composition_participants')
    op.drop_index(op.f('ix_schedule_id'), table_name='schedule')
    op.drop_table('schedule')
    op.drop_index(op.f('ix_responsible_id'), table_name='responsible')
    op.drop_table('responsible')
    op.drop_index(op.f('ix_composition_id'), table_name='composition')
    op.drop_table('composition')
    op.drop_index(op.f('ix_schedules_group_id'), table_name='schedules_group')
    op.drop_table('schedules_group')
    # ### end Alembic commands ###
