"""people_allocation_fields

Revision ID: 0005
Revises: 0004
Create Date: 2021-08-19 10:44:26.497193+00:00

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '0005'
down_revision = '0004'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint('interval_schedule_id_fkey', 'interval', type_='foreignkey')
    op.create_foreign_key(None, 'interval', 'schedule', ['schedule_id'], ['id'], ondelete='CASCADE')
    op.drop_constraint('interval_revision_revision_id_fkey', 'interval_revision', type_='foreignkey')
    op.drop_constraint('interval_revision_interval_id_fkey', 'interval_revision', type_='foreignkey')
    op.create_foreign_key(None, 'interval_revision', 'revision', ['revision_id'], ['id'], ondelete='CASCADE')
    op.create_foreign_key(None, 'interval_revision', 'interval', ['interval_id'], ['id'], ondelete='CASCADE')
    op.drop_constraint('revision_schedule_id_fkey', 'revision', type_='foreignkey')
    op.create_foreign_key(None, 'revision', 'schedule', ['schedule_id'], ['id'], ondelete='CASCADE')
    op.add_column('schedule', sa.Column('recalculation_in_process', sa.Boolean(), nullable=True))
    op.add_column('schedules_group', sa.Column('last_people_allocation_at', sa.DateTime(timezone=True), nullable=True))
    op.add_column('shift', sa.Column('predicted_ratings', sa.JSON(), nullable=True))
    op.add_column('shift', sa.Column('staff_id', sa.Integer(), nullable=True))
    op.drop_constraint('shift_schedule_id_fkey', 'shift', type_='foreignkey')
    op.create_foreign_key(None, 'shift', 'intranet_staff', ['staff_id'], ['id'])
    op.create_foreign_key(None, 'shift', 'schedule', ['schedule_id'], ['id'], ondelete='CASCADE')
    op.drop_constraint('slot_interval_id_fkey', 'slot', type_='foreignkey')
    op.create_foreign_key(None, 'slot', 'interval', ['interval_id'], ['id'], ondelete='CASCADE')
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(None, 'slot', type_='foreignkey')
    op.create_foreign_key('slot_interval_id_fkey', 'slot', 'interval', ['interval_id'], ['id'])
    op.drop_constraint(None, 'shift', type_='foreignkey')
    op.drop_constraint(None, 'shift', type_='foreignkey')
    op.create_foreign_key('shift_schedule_id_fkey', 'shift', 'schedule', ['schedule_id'], ['id'])
    op.drop_column('shift', 'staff_id')
    op.drop_column('shift', 'predicted_ratings')
    op.drop_column('schedules_group', 'last_people_allocation_at')
    op.drop_column('schedule', 'recalculation_in_process')
    op.drop_constraint(None, 'revision', type_='foreignkey')
    op.create_foreign_key('revision_schedule_id_fkey', 'revision', 'schedule', ['schedule_id'], ['id'])
    op.drop_constraint(None, 'interval_revision', type_='foreignkey')
    op.drop_constraint(None, 'interval_revision', type_='foreignkey')
    op.create_foreign_key('interval_revision_interval_id_fkey', 'interval_revision', 'interval', ['interval_id'], ['id'])
    op.create_foreign_key('interval_revision_revision_id_fkey', 'interval_revision', 'revision', ['revision_id'], ['id'])
    op.drop_constraint(None, 'interval', type_='foreignkey')
    op.create_foreign_key('interval_schedule_id_fkey', 'interval', 'schedule', ['schedule_id'], ['id'])
    # ### end Alembic commands ###
