"""composition_reference

Revision ID: 0007
Revises: 0006
Create Date: 2021-08-26 16:20:41.954617+00:00

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '0007'
down_revision = '0006'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('composition_excluded_roles',
    sa.Column('created_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('updated_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('composition_id', sa.Integer(), nullable=False),
    sa.Column('role_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['composition_id'], ['composition.id'], ),
    sa.ForeignKeyConstraint(['role_id'], ['roles_role.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_composition_excluded_roles_id'), 'composition_excluded_roles', ['id'], unique=False)
    op.create_table('composition_excluded_scopes',
    sa.Column('created_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('updated_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('composition_id', sa.Integer(), nullable=False),
    sa.Column('scope_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['composition_id'], ['composition.id'], ),
    sa.ForeignKeyConstraint(['scope_id'], ['roles_rolescope.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_composition_excluded_scopes_id'), 'composition_excluded_scopes', ['id'], unique=False)
    op.create_table('composition_excluded_staff',
    sa.Column('created_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('updated_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('composition_id', sa.Integer(), nullable=False),
    sa.Column('staff_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['composition_id'], ['composition.id'], ),
    sa.ForeignKeyConstraint(['staff_id'], ['intranet_staff.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_composition_excluded_staff_id'), 'composition_excluded_staff', ['id'], unique=False)
    op.create_table('composition_roles',
    sa.Column('created_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('updated_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('composition_id', sa.Integer(), nullable=False),
    sa.Column('role_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['composition_id'], ['composition.id'], ),
    sa.ForeignKeyConstraint(['role_id'], ['roles_role.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_composition_roles_id'), 'composition_roles', ['id'], unique=False)
    op.create_table('composition_scopes',
    sa.Column('created_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('updated_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('composition_id', sa.Integer(), nullable=False),
    sa.Column('scope_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['composition_id'], ['composition.id'], ),
    sa.ForeignKeyConstraint(['scope_id'], ['roles_rolescope.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_composition_scopes_id'), 'composition_scopes', ['id'], unique=False)
    op.create_table('composition_staff',
    sa.Column('created_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('updated_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('composition_id', sa.Integer(), nullable=False),
    sa.Column('staff_id', sa.Integer(), nullable=False),
    sa.ForeignKeyConstraint(['composition_id'], ['composition.id'], ),
    sa.ForeignKeyConstraint(['staff_id'], ['intranet_staff.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_composition_staff_id'), 'composition_staff', ['id'], unique=False)
    op.create_table('rating',
    sa.Column('created_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('updated_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('staff_id', sa.Integer(), nullable=False),
    sa.Column('schedule_id', sa.Integer(), nullable=False),
    sa.Column('rating', sa.Numeric(precision=7, scale=1), nullable=False),
    sa.ForeignKeyConstraint(['schedule_id'], ['schedule.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['staff_id'], ['intranet_staff.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_rating_id'), 'rating', ['id'], unique=False)
    op.add_column('composition', sa.Column('name', sa.String(), nullable=False))
    op.add_column('composition', sa.Column('slug', sa.String(), nullable=False))
    op.create_unique_constraint(None, 'composition', ['slug'])
    op.drop_constraint('composition_role_id_fkey', 'composition', type_='foreignkey')
    op.drop_constraint('composition_scope_id_fkey', 'composition', type_='foreignkey')
    op.drop_column('composition', 'role_id')
    op.drop_column('composition', 'scope_id')
    op.add_column('slot', sa.Column('points_per_hour', sa.Integer(), nullable=False))
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column('slot', 'points_per_hour')
    op.add_column('composition', sa.Column('scope_id', sa.INTEGER(), autoincrement=False, nullable=True))
    op.add_column('composition', sa.Column('role_id', sa.INTEGER(), autoincrement=False, nullable=True))
    op.create_foreign_key('composition_scope_id_fkey', 'composition', 'roles_rolescope', ['scope_id'], ['id'])
    op.create_foreign_key('composition_role_id_fkey', 'composition', 'roles_role', ['role_id'], ['id'])
    op.drop_constraint(None, 'composition', type_='unique')
    op.drop_column('composition', 'slug')
    op.drop_column('composition', 'name')
    op.drop_index(op.f('ix_rating_id'), table_name='rating')
    op.drop_table('rating')
    op.drop_index(op.f('ix_composition_staff_id'), table_name='composition_staff')
    op.drop_table('composition_staff')
    op.drop_index(op.f('ix_composition_scopes_id'), table_name='composition_scopes')
    op.drop_table('composition_scopes')
    op.drop_index(op.f('ix_composition_roles_id'), table_name='composition_roles')
    op.drop_table('composition_roles')
    op.drop_index(op.f('ix_composition_excluded_staff_id'), table_name='composition_excluded_staff')
    op.drop_table('composition_excluded_staff')
    op.drop_index(op.f('ix_composition_excluded_scopes_id'), table_name='composition_excluded_scopes')
    op.drop_table('composition_excluded_scopes')
    op.drop_index(op.f('ix_composition_excluded_roles_id'), table_name='composition_excluded_roles')
    op.drop_table('composition_excluded_roles')
    # ### end Alembic commands ###
