"""revision_next

Revision ID: 0008
Revises: 0007
Create Date: 2021-09-06 21:19:43.764312+00:00

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = '0008'
down_revision = '0007'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index('ix_interval_revision_id', table_name='interval_revision')
    op.drop_table('interval_revision')
    op.add_column('interval', sa.Column('revision_id', sa.Integer(), nullable=False))
    op.create_foreign_key(None, 'interval', 'revision', ['revision_id'], ['id'], ondelete='CASCADE')
    op.add_column('revision', sa.Column('apply_datetime', sa.DateTime(timezone=True), nullable=False))
    op.add_column('revision', sa.Column('next_id', sa.Integer(), nullable=True))
    op.create_foreign_key(None, 'revision', 'revision', ['next_id'], ['id'])
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(None, 'revision', type_='foreignkey')
    op.drop_column('revision', 'next_id')
    op.drop_column('revision', 'apply_datetime')
    op.drop_constraint(None, 'interval', type_='foreignkey')
    op.drop_column('interval', 'revision_id')
    op.create_table('interval_revision',
    sa.Column('created_at', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('updated_at', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('id', sa.INTEGER(), autoincrement=True, nullable=False),
    sa.Column('revision_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('interval_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.ForeignKeyConstraint(['interval_id'], ['interval.id'], name='interval_revision_interval_id_fkey', ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['revision_id'], ['revision.id'], name='interval_revision_revision_id_fkey', ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id', name='interval_revision_pkey')
    )
    op.create_index('ix_interval_revision_id', 'interval_revision', ['id'], unique=False)
    # ### end Alembic commands ###
