"""problem

Revision ID: 0009
Revises: 0008
Create Date: 2021-09-29 16:50:41.826859+00:00

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '0009'
down_revision = '0008'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('problem',
    sa.Column('created_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('updated_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('shift_id', sa.Integer(), nullable=False),
    sa.Column('staff_id', sa.Integer(), nullable=True),
    sa.Column('report_date', sa.DateTime(timezone=True), nullable=True),
    sa.Column('resolve_date', sa.DateTime(timezone=True), nullable=True),
    sa.Column('reason', sa.Enum('nobody_on_duty', 'staff_has_gap', name='problemreason'), nullable=False),
    sa.Column('status', sa.Enum('new', 'reported', 'resolved', name='problemstatus'), nullable=False),
    sa.ForeignKeyConstraint(['shift_id'], ['shift.id'], ),
    sa.ForeignKeyConstraint(['staff_id'], ['intranet_staff.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_problem_id'), 'problem', ['id'], unique=False)
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f('ix_problem_id'), table_name='problem')
    op.drop_table('problem')
    # ### end Alembic commands ###
