"""add_event_model

Revision ID: 0013
Revises: 0012
Create Date: 2021-11-16 11:45:48.095638+00:00

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '0013'
down_revision = '0012'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('event',
    sa.Column('created_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('updated_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('table', sa.String(), nullable=True),
    sa.Column('kind', sa.String(), nullable=True),
    sa.Column('obj_id', sa.Integer(), nullable=True),
    sa.Column('source', sa.Enum('logbroker', 'internal', name='eventsource'), nullable=True),
    sa.Column('type', sa.Enum('task', 'db_event', name='eventtype'), nullable=True),
    sa.Column('state', sa.Enum('new', 'scheduled', 'processed', name='eventstate'), nullable=False),
    sa.Column('remote_modified_at', sa.DateTime(timezone=True), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_event_id'), 'event', ['id'], unique=False)
    op.create_index(op.f('ix_event_remote_modified_at'), 'event', ['remote_modified_at'], unique=False)
    op.create_index(op.f('ix_event_source'), 'event', ['source'], unique=False)
    op.create_index(op.f('ix_event_state'), 'event', ['state'], unique=False)
    op.create_index(op.f('ix_event_type'), 'event', ['type'], unique=False)
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f('ix_event_type'), table_name='event')
    op.drop_index(op.f('ix_event_state'), table_name='event')
    op.drop_index(op.f('ix_event_source'), table_name='event')
    op.drop_index(op.f('ix_event_remote_modified_at'), table_name='event')
    op.drop_index(op.f('ix_event_id'), table_name='event')
    op.drop_table('event')
    # ### end Alembic commands ###
