"""change_responsibles

Revision ID: 0021
Revises: 0020
Create Date: 2022-01-30 11:27:02.854215+00:00

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = '0021'
down_revision = '0020'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index('ix_responsible_id', table_name='responsible')
    op.drop_constraint('schedule_group_responsible_responsible_id_fkey', 'schedule_group_responsible', type_='foreignkey')
    op.drop_constraint('schedule_group_responsible_schedule_group_id_fkey', 'schedule_group_responsible', type_='foreignkey')
    op.create_foreign_key(None, 'schedule_group_responsible', 'intranet_staff', ['responsible_id'], ['id'])
    op.create_foreign_key(None, 'schedule_group_responsible', 'schedules_group', ['schedule_group_id'], ['id'], ondelete='CASCADE')
    op.drop_constraint('schedule_responsible_responsible_id_fkey', 'schedule_responsible', type_='foreignkey')
    op.drop_constraint('schedule_responsible_schedule_id_fkey', 'schedule_responsible', type_='foreignkey')
    op.drop_table('responsible')
    op.create_foreign_key(None, 'schedule_responsible', 'intranet_staff', ['responsible_id'], ['id'])
    op.create_foreign_key(None, 'schedule_responsible', 'schedule', ['schedule_id'], ['id'], ondelete='CASCADE')
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column('shift', 'status')
    op.drop_column('services_servicemember', 'state')
    op.drop_constraint(None, 'schedule_responsible', type_='foreignkey')
    op.drop_constraint(None, 'schedule_responsible', type_='foreignkey')
    op.create_foreign_key('schedule_responsible_schedule_id_fkey', 'schedule_responsible', 'schedule', ['schedule_id'], ['id'])
    op.create_foreign_key('schedule_responsible_responsible_id_fkey', 'schedule_responsible', 'responsible', ['responsible_id'], ['id'])
    op.drop_constraint(None, 'schedule_group_responsible', type_='foreignkey')
    op.drop_constraint(None, 'schedule_group_responsible', type_='foreignkey')
    op.create_foreign_key('schedule_group_responsible_schedule_group_id_fkey', 'schedule_group_responsible', 'schedules_group', ['schedule_group_id'], ['id'])
    op.create_foreign_key('schedule_group_responsible_responsible_id_fkey', 'schedule_group_responsible', 'responsible', ['responsible_id'], ['id'])
    op.create_table('responsible',
    sa.Column('created_at', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('updated_at', postgresql.TIMESTAMP(timezone=True), autoincrement=False, nullable=True),
    sa.Column('id', sa.INTEGER(), autoincrement=True, nullable=False),
    sa.Column('type_responsible', postgresql.ENUM('staff', 'role', 'service', name='responsibletype'), autoincrement=False, nullable=False),
    sa.Column('staff_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.Column('role_id', sa.INTEGER(), autoincrement=False, nullable=True),
    sa.ForeignKeyConstraint(['role_id'], ['roles_role.id'], name='responsible_role_id_fkey'),
    sa.ForeignKeyConstraint(['staff_id'], ['intranet_staff.id'], name='responsible_staff_id_fkey'),
    sa.PrimaryKeyConstraint('id', name='responsible_pkey')
    )
    op.create_index('ix_responsible_id', 'responsible', ['id'], unique=False)
    # ### end Alembic commands ###
