"""notification

Revision ID: 0023
Revises: 0022
Create Date: 2022-02-02 09:33:33.760089+00:00

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '0023'
down_revision = '0022'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('notification',
    sa.Column('created_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('updated_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('staff_id', sa.Integer(), nullable=False),
    sa.Column('shift_id', sa.Integer(), nullable=False),
    sa.Column('valid_to', sa.DateTime(timezone=True), nullable=False),
    sa.Column('send_at', sa.DateTime(timezone=True), nullable=False),
    sa.Column('processed_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('type', sa.Enum('problem_nobody_on_duty', 'problem_staff_has_gap', 'start_shift', 'start_shift_soon',
                            name='notificationtype'), nullable=False),
    sa.Column('state', sa.Enum('new', 'send', 'outdated', name='notificationstate'), nullable=False),
    sa.ForeignKeyConstraint(['shift_id'], ['shift.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['staff_id'], ['intranet_staff.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_notification_id'), 'notification', ['id'], unique=False)
    op.create_index(op.f('ix_notification_send_at'), 'notification', ['send_at'], unique=False)
    op.create_index(op.f('ix_notification_state'), 'notification', ['state'], unique=False)
    op.create_index(op.f('ix_notification_type'), 'notification', ['type'], unique=False)
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f('ix_notification_type'), table_name='notification')
    op.drop_index(op.f('ix_notification_state'), table_name='notification')
    op.drop_index(op.f('ix_notification_send_at'), table_name='notification')
    op.drop_index(op.f('ix_notification_id'), table_name='notification')
    op.drop_table('notification')
    # ### end Alembic commands ###
