"""manual gap settings

Revision ID: 0028
Revises: 0027
Create Date: 2022-03-02 17:46:12.890011+00:00

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '0028'
down_revision = '0027'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('manual_gap_settings',
    sa.Column('created_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('updated_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('title', sa.String(), nullable=False),
    sa.Column('comment', sa.String(), nullable=True),
    sa.Column('staff_id', sa.Integer(), nullable=False),
    sa.Column('start', sa.DateTime(timezone=True), nullable=False),
    sa.Column('end', sa.DateTime(timezone=True), nullable=False),
    sa.Column('recurrence', sa.Enum('once', 'day', 'week', 'fortnight', 'month', name='manualgaprecurrence'), nullable=True),
    sa.Column('all_services', sa.Boolean(), nullable=True),
    sa.ForeignKeyConstraint(['staff_id'], ['intranet_staff.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('manual_gap_settings_services',
    sa.Column('created_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('updated_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('service_id', sa.Integer(), nullable=True),
    sa.Column('gap_settings_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['gap_settings_id'], ['manual_gap_settings.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['service_id'], ['services_service.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('manual_gap_settings_schedules',
    sa.Column('created_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('updated_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('schedule_id', sa.Integer(), nullable=True),
    sa.Column('gap_settings_id', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['gap_settings_id'], ['manual_gap_settings.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['schedule_id'], ['schedule.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id')
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('manual_gap_settings_schedules')
    op.drop_table('manual_gap_settings_services')
    op.drop_table('manual_gap_settings')
    # ### end Alembic commands ###
