"""abc_migration

Revision ID: 0036
Revises: 0035
Create Date: 2022-05-31 16:39:40.949508+00:00

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '0036'
down_revision = '0035'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('abc_migration',
    sa.Column('created_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('updated_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('service_id', sa.Integer(), nullable=False),
    sa.Column('schedule_id', sa.Integer(), nullable=True),
    sa.Column('abc_schedule_id', sa.Integer(), nullable=False),
    sa.Column('author_id', sa.Integer(), nullable=False),
    sa.Column('consider_other_schedules', sa.Boolean(), nullable=True),
    sa.Column('status', sa.Enum('created', 'preparing', 'preparing_fail', 'prepared', 'finalizing', 'finalizing_fail', 'finished', 'deleted', name='abcmigrationstatus'), nullable=False),
    sa.Column('migration_error', sa.JSON(), nullable=True),
    sa.ForeignKeyConstraint(['schedule_id'], ['schedule.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['service_id'], ['services_service.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['author_id'], ['intranet_staff.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('abc_migration')
    # ### end Alembic commands ###
