"""unistat

Revision ID: 0041
Revises: 0040
Create Date: 2022-06-28 10:26:25.811197+00:00

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '0041'
down_revision = '0040'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('task_metrics',
    sa.Column('created_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('updated_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('task_name', sa.String(), nullable=False),
    sa.Column('last_success_start', sa.DateTime(timezone=True), nullable=True),
    sa.Column('last_success_end', sa.DateTime(timezone=True), nullable=True),
    sa.Column('send_to_unistat', sa.Boolean(), nullable=True),
    sa.Column('use_for_monitoring', sa.Boolean(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_task_metrics_id'), 'task_metrics', ['id'], unique=False)
    op.create_table('unistat_record',
    sa.Column('created_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('updated_at', sa.DateTime(timezone=True), nullable=True),
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('metrics', sa.JSON(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_unistat_record_id'), 'unistat_record', ['id'], unique=False)
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f('ix_unistat_record_id'), table_name='unistat_record')
    op.drop_table('unistat_record')
    op.drop_index(op.f('ix_task_metrics_id'), table_name='task_metrics')
    op.drop_table('task_metrics')
    # ### end Alembic commands ###
