"""interval-rotation

Revision ID: 0042
Revises: 0041
Create Date: 2022-07-01 15:42:00.632611+00:00

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql


# revision identifiers, used by Alembic.
revision = '0042'
down_revision = '0041'
branch_labels = None
depends_on = None


intervalrotation = postgresql.ENUM(
    'default',
    'backup_is_next_primary',
    'primary_is_next_backup',
    'cross_rotation',
    name='intervalrotation'
)


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    intervalrotation.create(op.get_bind())
    op.add_column('schedule', sa.Column('rotation', intervalrotation, nullable=False, server_default='default'))
    op.alter_column('schedule', sa.Column('rotation', server_default=None, nullable=False))
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column('schedule', 'rotation')
    intervalrotation.drop(op.get_bind())
    # ### end Alembic commands ###
