from typing import List, Union

from fastapi import Request
from fastapi_utils.cbv import cbv
from fastapi_utils.inferring_router import InferringRouter
from watcher.tasks.unistat import calculate_unistat_metrics

from watcher.db import Unistat
from watcher.logic.exceptions import RecordNotFound
from .base import BaseRoute

router = InferringRouter()


@cbv(router)
class UnistatRoute(BaseRoute):
    model = Unistat

    # Переопределяем, для того чтобы выключить авторизацию
    def __init__(self, request: Request):
        self.request = request

    @router.get('/')
    def list(self) -> List[List[Union[int, float, str]]]:
        unistat_record = self.session.query(Unistat).first()
        if unistat_record is None:
            calculate_unistat_metrics.delay()
            raise RecordNotFound(message={
                'ru': 'Отсутствует запись с метриками',
                'en': 'Metrics record does not exist',
            })

        metrics = unistat_record.metrics
        return [[f'watcher_{key}_max', value] for key, value in metrics.items()]
