import datetime

from typing import Optional

from watcher.api.schemas.service import ServiceSchema
from watcher.api.schemas.schedule import ScheduleCompactSchema
from watcher.enums import ManualGapRecurrence

from .base import BaseSchema, optional


class ManualGapSettingsBaseSchema(BaseSchema):
    title: str
    comment: Optional[str]
    staff_id: int
    start: datetime.datetime
    end: datetime.datetime
    recurrence: ManualGapRecurrence
    all_services: bool


class ManualGapSettingsListSchema(ManualGapSettingsBaseSchema):
    id: int
    services: list[ServiceSchema]
    schedules: list[ScheduleCompactSchema]
    is_active: bool


@optional(
    'comment',
    'recurrence',
    'all_services',
    'services',
    'schedules',
)
class ManualGapSettingsCreateSchema(ManualGapSettingsBaseSchema):
    services: set[int]
    schedules: set[int]


@optional
class ManualGapSettingsPatchSchema(ManualGapSettingsBaseSchema):
    services: Optional[set[int]]
    schedules: Optional[set[int]]
