import datetime
from typing import Optional, Any

from pydantic.utils import GetterDict

from .base import BaseSchema


class ManualGapGetterDict(GetterDict):
    def get(self, key: str, default: Any = None) -> Any:
        if key in ('title', 'comment'):
            return getattr(self._obj.gap_settings, key)
        elif key in ('schedules', 'services'):
            return [obj.id for obj in getattr(self._obj, key)]
        else:
            return super().get(key, default)


class ManualGapBaseSchema(BaseSchema):
    id: int
    title: str
    comment: Optional[str]
    staff_id: int
    start: datetime.datetime
    end: datetime.datetime

    is_active: bool

    all_services: bool
    services: list[int]
    schedules: list[int]

    class Config(BaseSchema.Config):
        getter_dict = ManualGapGetterDict
