import datetime
from typing import List, Optional

from watcher.enums import RevisionState
from watcher.api.schemas.interval import IntervalListSchema

from .base import BaseSchema


class RevisionBaseSchema(BaseSchema):
    id: int
    schedule_id: int
    apply_datetime: datetime.datetime
    state: RevisionState


class RevisionListSchema(RevisionBaseSchema):
    intervals: List[IntervalListSchema]
    next_id: Optional[int] = None
    prev_id: Optional[int] = None
