from typing import Optional
from pydantic import NonNegativeInt

from .base import BaseSchema, optional


class SlotBaseSchema(BaseSchema):
    interval_id: int
    role_on_duty_id: Optional[int]
    composition_id: int
    show_in_staff: bool = False
    is_primary: bool = True
    points_per_hour: NonNegativeInt = 1


@optional(
    'id',
    'interval_id'
)
class SlotPutSchema(SlotBaseSchema):
    id: int


@optional
class SlotListSchema(SlotBaseSchema):
    id: int
    composition_id: Optional[int]


class SlotShortSchema(BaseSchema):
    is_primary: bool
    show_in_staff: bool


class SlotPatchSchema(BaseSchema):
    role_on_duty_id: Optional[int]
    show_in_staff: Optional[bool]
