import copy
from celery.schedules import crontab


CELERY_BEAT_SCHEDULE_BASE = {
    'start_shifts': {
        'task': 'watcher.tasks.shift.start_shifts',
        'schedule': crontab(),  # каждую минуту
    },
    'finish_shifts': {
        'task': 'watcher.tasks.shift.finish_shifts',
        'schedule': crontab(),
    },
    'approve_schedules_shifts': {
        'task': 'watcher.tasks.shift.approve_schedules_shifts',
        'schedule': crontab(),
    },
    'update_compositions': {
        'task': 'watcher.tasks.composition.update_compositions',
        'schedule': crontab(minute=0, hour=3),
    },
    'delete_autogenerated_groups_without_schedule': {
        'task': 'watcher.tasks.group.delete_autogenerated_groups_without_schedule',
        'schedule': crontab(minute=0, hour=4),
    },
    'start_people_allocation_for_groups_with_allocation_error': {
        'task': 'watcher.tasks.people_allocation.start_people_allocation_for_groups_with_allocation_error',
        'schedule': crontab(minute=0, hour='*/3'),
    },
    'process_changes_from_logbroker': {
        'task': 'watcher.tasks.sync.process_changes_from_logbroker',
        'schedule': crontab(minute='*/3'),
    },
    'send_scheduled_tasks': {
        'task': 'watcher.tasks.task_queue.send_scheduled_tasks',
        'schedule': crontab(),
    },
    'schedule_events': {
        'task': 'watcher.tasks.event_processing.schedule_events',
        'schedule': crontab(),
    },
    'remove_obsolete_ratings': {
        'task': 'watcher.tasks.rating.remove_obsolete_ratings',
        'schedule': crontab(minute=0, hour=4, day_of_week=1),
    },
    'resolve_shifts_problems': {
        'task': 'watcher.tasks.problem.resolve_shifts_problems',
        'schedule': crontab(minute=0),
    },
    'process_new_shifts_for_active_schedules': {
        'task': 'watcher.tasks.generating_shifts.process_new_shifts_for_active_schedules',
        'schedule': crontab(minute=0, hour=22),
    },
    'start_generate_manual_gaps': {
        'task': 'watcher.tasks.manual_gap.start_generate_manual_gaps',
        'schedule': crontab(minute=0, hour=21),
    },
    'send_notifications': {
        'task': 'watcher.tasks.notification.send_notifications',
        'schedule': crontab(),
    },
    'create_problem_notifications': {
        'task': 'watcher.tasks.notification.create_problem_notifications',
        'schedule': crontab(minute=0, hour=11),
    },
    'create_shift_start_soon_notifications': {
        'task': 'watcher.tasks.notification.create_shift_start_soon_notifications',
        'schedule': crontab(minute=0, hour=11),
    },
    'remove_unauthorized_bot_users': {
        'task': 'watcher.tasks.bot.remove_unauthorized_bot_users',
        'schedule': crontab(minute=0, hour='*/2'),
    },
    'calculate_unistat_metrics': {
        'task': 'watcher.tasks.unistat.calculate_unistat_metrics',
        'schedule': crontab(minute='*/15'),
    },
}


CELERY_BEAT_SCHEDULE_PROD = copy.deepcopy(CELERY_BEAT_SCHEDULE_BASE)
CELERY_BEAT_SCHEDULE_PROD.update(
    {
        'upload_duty_future': {
            'task': 'watcher.tasks.statistics.upload_duty_future',
            'schedule': crontab(minute=0, hour=3),
        },
        'upload_duty_to_yt': {
            'task': 'watcher.tasks.statistics.upload_duty_to_yt',
            'schedule': crontab(minute=0, hour=1, day_of_month='1,15'),
        },
        'sync_important_schedules': {
            'task': 'watcher.tasks.schedule.sync_important_schedules',
            'schedule': crontab(minute=0, hour=9),
        },
        'dump_events_to_yt': {
            'task': 'watcher.tasks.schedule.dump_events_to_yt',
            'schedule': crontab(minute=0, hour=4),
        },
    }

)
