from typing import Any
from collections import defaultdict
from pydantic import Field, SecretStr
from tvm2.ticket import ServiceTicket

from .default import Settings as DefaultSettings
from .duty_constants import DefaultConstants


class Settings(DefaultSettings, DefaultConstants):
    ENV_TYPE: str = 'development'

    POSTGRES_DATABASE: str = Field('watcher', env='PG_LOCAL_DATABASE')
    POSTGRES_USER: str = Field('postgres', env='PG_LOCAL_USER')
    POSTGRES_PASSWORD: str = Field('postgres', env='PG_LOCAL_PASSWORD')
    POSTGRES_HOSTS: str = Field('localhost', env='PG_LOCAL_HOST')
    POSTGRES_PORT: str = Field(5432, env='PG_LOCAL_PORT')

    tvm2_client: str = '28'
    tvm2_secret: SecretStr = 'secret'

    CELERY_TASK_ALWAYS_EAGER: bool = True
    LOCKS_ENABLED: bool = False

    LOGBROKER_TOKEN: str = 'token'
    LOGBROKER_PORT: int = 2135
    LOGBROKER_ABC_TOPIC: str = 'some-topic'
    LOGBROKER_ABC_CONSUMER: str = 'some-consumer'

    test_user_data: dict[str, Any] = {
        'uid': '123',
        'fields': {
            'email': 'test_user@yandex.ru',
        },
        'auth_type': 'test',
        'service_ticket': ServiceTicket(defaultdict(str))
    }

    BOT_TOKEN: str = '5099989999:AAfdsfsdgXdlw92UlulE_fake'
    BOT_USE_GOZORA: bool = False
