from dateutil.relativedelta import relativedelta
from dateutil import rrule

from watcher.enums import ManualGapRecurrence


class DefaultConstants:
    MIN_COUNT_OF_CYCLES: int = 2

    PAGE_SIZE: int = 30
    MAX_PAGE_SIZE: int = 1001

    TOTAL_SECONDS_FOR_UPDATING_COMPOSITION: int = 172800  # два дня
    DONT_APPROVE_DISAPPROVED_SHIFTS_FOR: int = 600  # 10 минут

    RESPONSIBLE_ROLE_CODE: str = 'responsible'

    MIN_THRESHOLD_DAYS: int = 259200 * 7  # 7 дней
    MAX_THRESHOLD_DAYS: int = 259200 * 60  # 180 дней
    MAX_PROBLEM_OR_NOTIFICATION_DAYS = 30
    MAX_DAYS_BEFORE_OR_AFTER_VACATION = 30
    MAX_TIMEOUT_BETWEEN_SHIFTS_DAYS = 60
    DATA_TRANSFER_SYSTEM_TABLES = (
        '__consumer_keeper', 'intranet_staff', 'roles_rolescope', 'roles_role'
    )

    OWN_ONLY_VIEWER_ID: int = 984  # силно ограниченная роль
    SERVICES_VIEWER_ID: int = 986  # ограниченная роль
    FULL_ACCESS_ID: int = 992  # штатная роль

    SUPERUSERS: set = {
        'smosker', 'swetlanka', 'kir-choo',
        'pixel', 'alexkoshelev', 'darialari',
        'el-makarova', 'roma-vat', 'tsufiev',
        'yurokshar', 'trshkv', 'atakin', 'atridis',
        'pluzhnikovad', 'zomb-prj-282',
    }

    TASKS_FOR_QUEUE = {
        'start_people_allocation',
        'update_composition',
    }

    FORCE_TASK_DELAY = 'force_task_delay'
    ENV_TYPE_PRODUCTION = 'production'
    ENV_TYPE_TESTING = 'testing'
    ENV_TYPE_DEVELOPMENT = 'development'
    ENV_TYPE_FOR_UNIT_TEST = {ENV_TYPE_DEVELOPMENT, 'production_for_unit_tests'}

    START_SOON_NOTIFY_VALID = 12  # часов
    START_NOTIFY_VALID = 15  # минут

    GAP_RECURRENCE_TO_DT = {
        ManualGapRecurrence.day: ({'freq': rrule.DAILY}, relativedelta(days=1)),
        ManualGapRecurrence.week: ({'freq': rrule.WEEKLY}, relativedelta(days=7)),
        ManualGapRecurrence.fortnight: ({'freq': rrule.WEEKLY, 'interval': 2}, relativedelta(days=14)),
        ManualGapRecurrence.month: ({'freq': rrule.MONTHLY}, relativedelta(months=1)),
    }


class ProductionConstants(DefaultConstants):

    OWN_ONLY_VIEWER_ID: int = 939
    SERVICES_VIEWER_ID: int = 941
    FULL_ACCESS_ID: int = 947


class TestingConstants(DefaultConstants):
    pass
