from typing import Set

from .default import Settings as DefaultSettings
from .duty_constants import ProductionConstants
from .celery_beat import CELERY_BEAT_SCHEDULE_PROD


class Settings(DefaultSettings, ProductionConstants):
    ENV_TYPE: str = 'production'
    DEBUG: bool = False

    tvm2_client: str = '2027882'
    TVM_SERVICES: dict = {
        'abc': 2012190,
        'jns': 2029080,
        'gozora': 2023123,
        # 'passport': 223,
        'staff-api': 2001974,
        # 'intrasearch': 2001043,
        # 'idm': 2001600,
    }

    STAFF_API_HOST: str = 'https://staff-api.yandex-team.ru/'
    STAFF_HOST: str = 'https://staff.yandex-team.ru/'
    ABC_API_HOST = 'https://abc-back.yandex-team.ru/'

    BOT_KEY = 'watcher-prod'
    JNS_PROJECT = 'Watcher'
    ABC_HOST = 'abc.yandex-team.ru'
    GOZORA_CLIENT_ID = 'watcher_prod'

    ALLOWED_TVM_CLIENT_FOR_UID_HEADER: Set[int] = {2018744, 2012190}

    CELERY_BEAT_SCHEDULE = CELERY_BEAT_SCHEDULE_PROD

    NOTIFY_STAFF = True
