from typing import Iterable, Optional

from sqlalchemy.orm import Query, Session

from watcher import enums
from watcher.db import Event


def update_events_statuses(db: Session, ids: Iterable[int], state: enums.EventState, query: Optional[Query] = None):
    if query is None:
        query = db.query(Event)

    query.filter(
        Event.id.in_(ids),
    ).update(
        {Event.state: state},
        synchronize_session=False,
    )
