import datetime
import operator

from sqlalchemy.orm import Session
from sqlalchemy.orm.query import Query

from watcher.db import Holiday


def get_end_date_comparer(check_date, end):
    target_operator = operator.le
    if end.time() == datetime.time(0, 0):
        #  смена заканчивается в 00:00 - значит условие фильтрации выходных
        #  должно быть строго <
        target_operator = operator.lt
    return target_operator(check_date, end.date())


def get_holidays(db: Session, start: datetime.datetime, end: datetime.datetime) -> Query:
    """Получаем все выходные/праздники" за указанный период"""

    return db.query(Holiday).filter(
        Holiday.date >= start.date(),
        get_end_date_comparer(Holiday.date, end)
    ).order_by(Holiday.date)
