from sqlalchemy.orm import Session, Query

from watcher.db import UserPermission


def query_permissions_by_user(db: Session, user_id: int) -> Query:
    return db.query(UserPermission).filter(UserPermission.user_id == user_id)


def has_perm(db: Session, user_id: int, permission_ids: list[int]) -> bool:
    return (
        db.query(
            query_permissions_by_user(db=db, user_id=user_id)
            .filter(UserPermission.permission_id.in_(permission_ids))
            .exists()
        ).scalar()
    )
