from typing import List
from sqlalchemy.orm import Session, joinedload

from watcher.db import Role


def get_role_by_code(db: Session, code: str) -> Role:
    return db.query(Role).filter(Role.code == code).first()


def get_role_by_id(db: Session, role_id: int) -> Role:
    return db.query(Role).filter(Role.id == role_id).options(joinedload(Role.scope)).first()


def get_roles_by_ids(db: Session, role_ids: List[int]) -> List[Role]:
    return db.query(Role).filter(
        Role.id.in_(role_ids)
    ).options(joinedload(Role.scope)).all()
