from typing import Iterable, List

from sqlalchemy.orm import Session
from watcher.db import Service


def get_services_by_ids(db: Session, services_ids: Iterable[int]) -> List[Service]:
    return db.query(Service).filter(
        Service.id.in_(services_ids)
    ).all()
