from typing import Iterable, List, Optional

from sqlalchemy.orm import Session, Query

from watcher.db import Interval, Schedule, Slot


def get_slots_by_ids(db: Session, slot_ids: Iterable[int]) -> List[Slot]:
    objects = db.query(Slot).filter(
        Slot.id.in_(slot_ids)
    ).all()

    return objects


def query_slots_by_schedule(db: Session, schedule_id: int, query: Optional[Query] = None) -> Query:
    if not query:
        query = db.query(Slot)

    return (
        query
        .join(Interval, Slot.interval_id == Interval.id)
        .filter(Interval.schedule_id == schedule_id)
    )


def query_slots_by_service(db: Session, service_id: int, query: Optional[Query] = None) -> Query:
    if not query:
        query = db.query(Slot)

    return (
        query
        .join(Interval, Slot.interval_id == Interval.id)
        .join(Schedule, Interval.schedule_id == Schedule.id)
        .filter(Schedule.service_id == service_id)
    )
