from .base import BaseModel, TimestampedModelMixin
from sqlalchemy import (
    Column,
    ForeignKey,
    types,
)
from sqlalchemy.orm import relationship

from watcher import enums


class AbcMigration(TimestampedModelMixin, BaseModel):
    __tablename__ = 'abc_migration'

    id = Column(types.Integer, primary_key=True)
    service_id = Column(types.Integer, ForeignKey('services_service.id', ondelete='CASCADE'), nullable=False)
    service = relationship('Service')
    schedule_id = Column(types.Integer, ForeignKey('schedule.id', ondelete='CASCADE'), nullable=True)
    schedule = relationship('Schedule')
    abc_schedule_id = Column(types.Integer, nullable=False)
    author_id = Column(types.Integer, ForeignKey('intranet_staff.id'), nullable=False,)
    author = relationship('Staff', foreign_keys=[author_id])
    consider_other_schedules = Column(
        types.Boolean,
        default=False,
        info={
            'verbose_name': 'Признак того, что расписания сервиса обьеденены в группу'
        }
    )
    status = Column(
        types.Enum(enums.AbcMigrationStatus),
        nullable=False,
        default=enums.AbcMigrationStatus.created,
        info={
            'verbose_name': 'Статус миграции'
        },
    )
    migration_error = Column(
        types.JSON,
        nullable=True,
        info={
            'verbose_name': 'Ошибка миграции'
        },
    )
