from .base import BaseModel, TimestampedModelMixin
from sqlalchemy import (
    Column,
    ForeignKey,
    types,
)
from sqlalchemy.orm import relationship

from watcher.enums import ChatType


class BotUser(TimestampedModelMixin, BaseModel):
    __tablename__ = 'bot_user'

    id = Column(types.Integer, primary_key=True, index=True)

    staff_id = Column(types.Integer, ForeignKey('intranet_staff.id'), nullable=False,)
    staff = relationship('Staff', foreign_keys=[staff_id])

    username = Column(types.String, unique=True, nullable=False)
    telegram_id = Column(types.String, unique=True, nullable=False)


class Chat(TimestampedModelMixin, BaseModel):
    __tablename__ = 'chat'

    id = Column(types.Integer, primary_key=True, autoincrement=False)  # chat id
    title = Column(types.String, nullable=False)
    chat_type = Column(
        types.Enum(ChatType),
        nullable=False,
    )

    author_id = Column(types.Integer, ForeignKey('bot_user.id', ondelete='CASCADE'), nullable=False,)
    author = relationship('BotUser', foreign_keys=[author_id])
