from .base import BaseModel, TimestampedModelMixin

from sqlalchemy import Column, types

from watcher import enums


class Event(TimestampedModelMixin, BaseModel):
    __tablename__ = 'event'

    id = Column(types.Integer, primary_key=True, index=True)

    table = Column(types.String)
    kind = Column(types.String)  # например: insert, update, delete
    obj_id = Column(types.Integer)

    source = Column(types.Enum(enums.EventSource), index=True)
    type = Column(types.Enum(enums.EventType), index=True)
    state = Column(types.Enum(enums.EventState), nullable=False, default=enums.EventState.new, index=True)
    object_data = Column(types.JSON, default=dict)
    old_keys = Column(types.JSON, default=dict)

    remote_modified_at = Column(types.DateTime(timezone=True), index=True)
