from .base import BaseModel, TimestampedModelMixin
from sqlalchemy import (
    Column,
    ForeignKey,
    types,
)
from sqlalchemy.orm import relationship

from watcher import enums


class Notification(TimestampedModelMixin, BaseModel):
    __tablename__ = 'notification'

    id = Column(types.Integer, primary_key=True, index=True)

    staff_id = Column(types.Integer, ForeignKey('intranet_staff.id'), nullable=False,)
    staff = relationship('Staff', foreign_keys=[staff_id])

    shift_id = Column(types.Integer, ForeignKey('shift.id', ondelete='CASCADE'), nullable=False,)
    shift = relationship('Shift', foreign_keys=[shift_id], backref='notifications')

    valid_to = Column(types.DateTime(timezone=True), nullable=False,)
    send_at = Column(types.DateTime(timezone=True), nullable=False, index=True)
    processed_at = Column(types.DateTime(timezone=True))

    type = Column(types.Enum(enums.NotificationType), index=True, nullable=False)
    state = Column(
        types.Enum(enums.NotificationState), nullable=False,
        default=enums.NotificationState.new, index=True,
    )
