from .base import BaseModel, TimestampedModelMixin
from sqlalchemy import (
    Column,
    ForeignKey,
    types,
)
from sqlalchemy.orm import backref, relationship

from watcher import enums


class Problem(TimestampedModelMixin, BaseModel):
    __tablename__ = 'problem'

    id = Column(types.Integer, primary_key=True, index=True)

    shift_id = Column(types.Integer, ForeignKey('shift.id', ondelete='CASCADE'), nullable=False)
    shift = relationship('Shift', foreign_keys=[shift_id], backref=backref('problems', remote_side=[shift_id],))
    staff_id = Column(types.Integer, ForeignKey('intranet_staff.id'))
    staff = relationship('Staff', foreign_keys=[staff_id])
    duty_gap_id = Column(types.Integer, ForeignKey('duty_gap.id'))
    duty_gap = relationship('Gap', foreign_keys=[duty_gap_id])
    manual_gap_id = Column(types.Integer, ForeignKey('manual_gap.id'))
    manual_gap = relationship('ManualGap', foreign_keys=[manual_gap_id])

    report_date = Column(types.DateTime(timezone=True), info={
        'verbose_name': 'Дата отправки уведомления о создании проблемы'
    })
    resolve_date = Column(types.DateTime(timezone=True))

    reason = Column(types.Enum(enums.ProblemReason), nullable=False)
    status = Column(
        types.Enum(enums.ProblemStatus),
        default=enums.ProblemStatus.new,
        nullable=False
    )
