from sqlalchemy import (
    Column,
    ForeignKey,
    types,
)
from sqlalchemy.orm import backref, relationship

from .base import BaseModel, TimestampedModelMixin


class Rating(TimestampedModelMixin, BaseModel):
    """
        Рейтинги сотрудников в расписаниях
    """
    __tablename__ = 'rating'
    id = Column(types.Integer, primary_key=True, index=True)

    staff_id = Column(types.Integer, ForeignKey('intranet_staff.id'), nullable=False)
    staff = relationship('Staff', backref=backref('ratings', remote_side=[staff_id]))

    schedule_id = Column(types.Integer, ForeignKey('schedule.id', ondelete='CASCADE'), nullable=False)
    schedule = relationship('Schedule')

    rating = Column(types.Numeric(7, 1), default=0, nullable=False)
