
from sqlalchemy import (
    Column,
    types,
)

from .base import BaseModel, TimestampedModelMixin
from watcher.logic.timezone import now


class Unistat(BaseModel):
    __tablename__ = 'unistat_record'

    id = Column(types.Integer, primary_key=True, index=True)
    metrics = Column(
        types.JSON,
        nullable=True,
        info={
            'verbose_name': 'Метрики, собираемые по расписанию'
        },
    )


class TaskMetric(TimestampedModelMixin, BaseModel):
    __tablename__ = 'task_metrics'

    id = Column(types.Integer, primary_key=True, index=True)
    task_name = Column(types.String, nullable=False, )
    last_success_start = Column(types.DateTime(timezone=True), nullable=True, default=now)
    last_success_end = Column(types.DateTime(timezone=True), nullable=True, default=now)
    send_to_unistat = Column(types.Boolean)
    use_for_monitoring = Column(types.Boolean, default=True)
