from enum import auto

from fastapi_utils.enums import StrEnum


class ScheduleState(StrEnum):
    active = auto()
    disabled = auto()


class ChatType(StrEnum):
    private = auto()
    group = auto()
    channel = auto()
    supergroup = auto()

    @classmethod
    def group_types(cls) -> set:
        return {
            cls.group,
            cls.channel,
            cls.supergroup,
        }


class IntervalTypeEmployment(StrEnum):
    full = auto()
    empty = auto()


class IntervalUnexpectedHolidays(StrEnum):
    remove = auto()
    ignoring = auto()


class IntervalWeekendsBehaviour(StrEnum):
    extend = auto()
    ignoring = auto()


class RevisionState(StrEnum):
    active = auto()
    disabled = auto()


class CompositionType(StrEnum):
    empty = auto()
    role = auto()
    scope = auto()
    service = auto()


class ShiftStatus(StrEnum):
    scheduled = auto()
    active = auto()
    completed = auto()


class GapStatus(StrEnum):
    active = auto()
    deleted = auto()


class GapType(StrEnum):
    absence = auto()
    conference = auto()
    conference_trip = auto()
    duty = auto()
    illness = auto()
    learning = auto()
    maternity = auto()
    paid_day_off = auto()
    trip = auto()
    vacation = auto()


class MemberState(StrEnum):
    requested = auto()
    active = auto()
    depriving = auto()
    deprived = auto()


class ServiceState(StrEnum):
    develop = auto()
    supported = auto()
    needinfo = auto()
    closed = auto()
    deleted = auto()

    ALL_STATES = {
        develop,
        supported,
        needinfo,
        closed,
        deleted,
    }

    ALIVE_STATES = ALL_STATES - {deleted}
    ACTIVE_STATES = ALIVE_STATES - {closed}
    NORMAL_STATES = ACTIVE_STATES - {needinfo}


class StaffGender(StrEnum):
    M = auto()
    F = auto()


class StaffAffilation(StrEnum):
    yandex = auto()
    yamoney = auto()
    external = auto()


class StaffLang(StrEnum):
    en = auto()
    ru = auto()
    tr = auto()


class ServiceReadonlyStatus(StrEnum):
    creating = auto()
    moving = auto()
    renaming = auto()
    deleting = auto()
    closing = auto()


class ProblemReason(StrEnum):
    nobody_on_duty = auto()
    staff_has_gap = auto()


class ProblemStatus(StrEnum):
    new = auto()
    reported = auto()
    resolved = auto()


class EventSource(StrEnum):
    logbroker = auto()
    internal = auto()


class EventType(StrEnum):
    task = auto()
    db_event = auto()


class EventState(StrEnum):
    new = auto()
    scheduled = auto()
    processed = auto()


class NotificationType(StrEnum):
    problem_nobody_on_duty = auto()
    problem_staff_has_gap = auto()
    start_shift = auto()
    start_shift_soon = auto()


class NotificationState(StrEnum):
    new = auto()
    send = auto()
    outdated = auto()


class JnsChannel(StrEnum):
    email = auto()
    telegram = auto()


class ManualGapRecurrence(StrEnum):
    once = auto()
    day = auto()
    week = auto()
    fortnight = auto()
    month = auto()


class AbcMigrationStatus(StrEnum):
    created = auto()
    preparing = auto()
    preparing_fail = auto()
    prepared = auto()
    finalizing = auto()
    finalizing_fail = auto()
    finished = auto()
    deleted = auto()


class IntervalRotation(StrEnum):
    default = auto()
    backup_is_next_primary = auto()
    primary_is_next_backup = auto()
    cross_rotation = auto()
