import sys

from celery.signals import setup_logging

from watcher.config import settings


def setup_celery_logging(*args, **kwargs):
    pass


setup_logging.connect(setup_celery_logging)

LOG_FORMAT = 'json' if settings.ENV_TYPE != 'development' else 'default'
ENV_LOG_LEVEL = 'DEBUG' if settings.DEBUG or settings.ENV_TYPE == 'development' else 'INFO'

LOGGING_CONFIG = {
    'version': 1,
    'disable_existing_loggers': False,
    'formatters': {
        'default': {
            '()': 'ylog.context.ContextFormatter',
            'datefmt': '%Y-%m-%d %H:%M:%S',
            'format': '[%(asctime)s][%(name)s] - %(levelname)s - %(message)s',
        },
        'json': {
            '()': 'ylog.format.QloudJsonFormatter',
        },
    },
    'handlers': {
        'stream': {
            'class': 'logging.StreamHandler',
            'formatter': LOG_FORMAT,
            'stream': sys.stdout,
            'level': ENV_LOG_LEVEL,
        },
    },
    'loggers': {
        'tvm2.aio.base': {
            'handlers': ['stream'],
            'level': ENV_LOG_LEVEL,
            'propagate': False,
        },
        'botocore.auth': {
            'handlers': ['stream'],
            'level': 'INFO',
            'propagate': False,
        },
        'telegram': {
            'handlers': ['stream'],
            'level': 'INFO',
            'propagate': False,
        },
        'ylock': {
            'handlers': ['stream'],
            'level': 'INFO',
            'propagate': False,
        },
        'yt.packages': {
            'handlers': ['stream'],
            'level': 'INFO',
            'propagate': False,
        },
        'botocore': {
            'handlers': ['stream'],
            'level': 'INFO',
            'propagate': False,
        },
        'asgi_yauth': {
            'handlers': ['stream'],
            'level': 'INFO',
            'propagate': False,
        },
        'asyncio': {
            'handlers': ['stream'],
            'level': 'INFO',
            'propagate': False,
        },
        'ydb.public.sdk.python.ydb.connection': {
            'handlers': ['stream'],
            'level': 'WARNING',
            'propagate': False,
        },
        'watcher': {
            'handlers': ['stream'],
            'propagate': False,
            'level': ENV_LOG_LEVEL,
        },
        'ya.test': {'level': 'WARNING'},
        'httpx.client': {'level': 'WARNING'},
        'celery.worker.consumer': {
            'level': 'WARNING',
            'propagate': False,
            'handlers': ['stream'],
        },
    },
    'root': {
        'handlers': ['stream'],
        'level': ENV_LOG_LEVEL,
    },
}
