from .base import BaseClient
from watcher.config import settings


class StaffClient(BaseClient):

    OAUTH_TOKEN = settings.ROBOT_TOKEN
    HOST = settings.STAFF_HOST

    def notify_duty(self, service_id: int, service_slug: str) -> None:
        self._make_request(
            method='post',
            path=f'/gap-api/api/need_update_gap/{service_id}/',
            data={
                'service_slug': service_slug,
            },
        )


staff_client = StaffClient()
