from watcher.db import Composition
from watcher.logic.timezone import now
from watcher.config import settings


def composition_need_updating(composition: Composition) -> bool:
    time_passed_since_last_update = now() - composition.updated_at

    if time_passed_since_last_update.total_seconds() > settings.TOTAL_SECONDS_FOR_UPDATING_COMPOSITION:
        return True

    return False
