from .base import BaseProvider


class Provider(BaseProvider):
    required_kwargs = ['request']

    def user(self, request):
        if getattr(request, 'user', None) is None:
            return None
        if not request.user.is_authenticated():
            return None
        user = request.user
        return {
            'uid': user.uid,
        }

    def auth(self, request):
        if getattr(request, 'user', None) is None:
            return {'mechanism': None}
        if not request.user.is_authenticated():
            return {'mechanism': None}
        if not request.user.authenticated_by():
            return {'mechanism': 'unknown - request.user.authenticated_by is None'}
        ctx = {
            'mechanism': request.user.authenticated_by()
        }
        if request.user.authenticated_by() == 'oauth':
            ctx['application'] = request.user.blackbox_result.oauth.client_name
        if request.user.authenticated_by() == 'tvm2':
            ctx['application'] = request.user.service_ticket.src
        return ctx
