import uuid

from urllib.parse import parse_qs
from starlette.routing import Match

from watcher.config import settings
from .base import BaseProvider


class Provider(BaseProvider):
    required_kwargs = ['request']

    def _get_route(self, request):
        for route in request.scope['app'].routes:
            if route.matches(request)[0] == Match.FULL:
                return route

    def _get_headers(self, request):
        for header, not_secure in settings.LOG_CONTEXT_ALLOWED_HEADERS:
            value = request.headers.get(header)
            if value is not None:
                yield header, value if not_secure else '******'

    def _get_query_params(self, request):
        return parse_qs(request.scope['query_string'].decode('utf-8'))

    def request(self, request):
        route = self._get_route(request)
        return {
            'id': request.headers.get('X-Request-ID') or str(uuid.uuid4()),
            'method': request.method,
            'path': request.url.path,
            'query_params': self._get_query_params(request),
            'headers': dict(self._get_headers(request)),
            'endpoint_path': getattr(route, 'path', ''),
            'endpoint': getattr(
                getattr(route, 'endpoint', None),
                '__qualname__',
                'unknown',
            ),
        }
