from contextvars import ContextVar


class StateItem(object):
    def __init__(self):
        self.reset()

    def reset(self):
        self.requests_time = 0
        self.requests_count = 0
        self.sql_time = 0
        self.sql_count = 0

    def add_requests_time(self, requests_time):
        self.requests_time += requests_time
        self.requests_count += 1

    def add_sql_time(self, sql_time):
        self.sql_time += sql_time
        self.sql_count += 1

    def __repr__(self):
        return 'requests(%d, %d), sql(%d, %d)' % (
            self.requests_time, self.requests_count,
            self.sql_time, self.sql_count,
        )


context_state = ContextVar('context_state', default=StateItem())
