import logging

from watcher.logic.timezone import now
from watcher.db import Problem
from watcher.enums import ProblemStatus

logger = logging.getLogger(__name__)


def resolve_problem(problem: Problem) -> None:
    logger.info(
        f'Resolving problem: {problem.id}, '
        f'shift: {problem.shift_id}, staff: {problem.staff_id}'
    )
    problem.status = ProblemStatus.resolved
    problem.resolve_date = now()


def is_resolved(problem: Problem) -> bool:
    return problem.status == ProblemStatus.resolved
