import datetime

from sqlalchemy.orm import Session

from watcher.db import Schedule
from watcher.crud.schedule import query_schedules_without_allocation
from watcher.logic.timezone import now
from watcher import enums


def get_people_allocation_start_date(session: Session, schedules_group_id: int) -> datetime.datetime:
    schedule_data = query_schedules_without_allocation(session, schedules_group_id).first()

    if not schedule_data:
        return now()
    _, revision = schedule_data
    return min(revision.apply_datetime, now())


def get_composition_id_for_rotation(schedule: Schedule) -> int | None:
    for interval in schedule.intervals:
        if interval.type_employment != enums.IntervalTypeEmployment.empty and interval.slots:
            return interval.slots[0].composition_id
