import datetime
from typing import Union, Optional

from watcher.config import settings


def round_to_minute(tm: datetime.datetime) -> datetime.datetime:
    discard = datetime.timedelta(seconds=tm.second, microseconds=tm.microsecond)
    tm -= discard
    return tm


def localize(d: Union[datetime.datetime, datetime.datetime.date]) -> datetime.datetime:
    return d.astimezone(settings.DEFAULT_TIMEZONE)


def today():
    return localize(datetime.datetime.now()).date()


def now():
    return round_to_minute(localize(datetime.datetime.now()))


def make_localized_datetime(date: datetime.date, time: Optional[datetime.time] = None):
    return settings.DEFAULT_TIMEZONE.localize(datetime.datetime.combine(
        date,
        time or datetime.datetime.min.time(),
    ))
