from tvm2.sync.thread_tvm2 import TVM2
from watcher.config import settings


def get_tvm2_ticket(destination: str):
    client = get_tvm2_client()
    tvm_id = settings.TVM_SERVICES[destination]
    return client.get_service_ticket(tvm_id)


def get_tvm2_client():
    secret = settings.tvm2_secret.get_secret_value()
    return TVM2(
        client_id=settings.tvm2_client,
        secret=secret,
        blackbox_client=settings.tvm2_blackbox_client,
        allowed_clients=settings.tvm2_allowed_clients,
        destinations=settings.TVM_SERVICES.values(),
    )
