import os
import subprocess

from logging.config import dictConfig

from watcher.logic.logger.httptracking import enable_http_instrumentation
from watcher.logic.logger.sqltracking import enable_sql_instrumentation
from .config import settings


def dbshell():
    pgshell = os.environ.get('PGSHELL', 'pgcli')

    command = 'PGPASSWORD={password} '.format(
        password=settings.POSTGRES_PASSWORD
    )

    target_session_attrs_opt = 'target_session_attrs=read-write'

    command += (
        '{pgshell} -d "'
        'host={host} '
        'port={port} '
        'sslmode=verify-full '
        'dbname={database} '
        'user={user} '
        '{target_session_attrs_opt}"'
    ).format(
        pgshell=pgshell,
        target_session_attrs_opt=target_session_attrs_opt,
        host=settings.POSTGRES_HOST,
        port=settings.POSTGRES_PORT,
        database=settings.POSTGRES_DATABASE,
        user=settings.POSTGRES_USER,
    )
    subprocess.call(command, shell=True)


def celery_manage():
    enable_http_instrumentation()
    enable_sql_instrumentation()
    from .logging import LOGGING_CONFIG  # noqa: F401
    dictConfig(LOGGING_CONFIG)
    from . import celery_app  # noqa: F401
    from celery.bin.celery import main
    return main()


def bot_manage():
    enable_http_instrumentation()
    enable_sql_instrumentation()
    from .logging import LOGGING_CONFIG  # noqa: F401
    dictConfig(LOGGING_CONFIG)
    from .bot.core import BotHandler
    bot = BotHandler()
    bot.run()
