from fastapi import APIRouter

from watcher.api.routes.abc_migration import router as abc_migration_router
from watcher.api.routes.composition import router as composition_router
from watcher.api.routes.service import delete_all_about_duty_router
from watcher.api.routes.service import router as service_router
from watcher.api.routes.interval import router as interval_router
from watcher.api.routes.problem import router as problem_router
from watcher.api.routes.revision import router as revision_router
from watcher.api.routes.schedule import router as schedule_router
from watcher.api.routes.schedulegroup import router as schedulegroup_router
from watcher.api.routes.shift import router as shift_router
from watcher.api.routes.subshifts import router as subshift_router
from watcher.api.routes.gap_settings import router as gap_settings_router
from watcher.api.routes.manual_gap import router as manual_gap_router
from watcher.api.routes.slot import router as slot_router


api_router = APIRouter()

api_router.include_router(abc_migration_router, prefix='/abc_migration', tags=['abc_migration'],)
api_router.include_router(schedule_router, prefix='/schedule', tags=['schedule'],)
api_router.include_router(schedulegroup_router, prefix='/schedule_group', tags=['schedule_group'],)
api_router.include_router(shift_router, prefix='/shift', tags=['shift'],)
api_router.include_router(subshift_router, prefix='/subshift', tags=['subshift'],)
api_router.include_router(interval_router, prefix='/interval', tags=['interval'])
api_router.include_router(composition_router, prefix='/composition', tags=['composition'])
api_router.include_router(revision_router, prefix='/revision', tags=['revision'])
api_router.include_router(problem_router, prefix='/problem', tags=['problem'])
api_router.include_router(service_router, prefix='/service', tags=['service'])
api_router.include_router(gap_settings_router, prefix='/settings/gap', tags=['manual_gap_settings'])
api_router.include_router(manual_gap_router, prefix='/manual_gaps', tags=['manual_gap'])
api_router.include_router(slot_router, prefix='/slot', tags=['slot'])

frontend_router = APIRouter()

frontend_router.include_router(abc_migration_router, prefix='/abc_migration', tags=['abc_migration'],)
frontend_router.include_router(schedule_router, prefix='/schedule', tags=['schedule'],)
frontend_router.include_router(schedulegroup_router, prefix='/schedule_group', tags=['schedule_group'],)
frontend_router.include_router(shift_router, prefix='/shift', tags=['shift'],)
frontend_router.include_router(subshift_router, prefix='/subshift', tags=['subshift'],)
frontend_router.include_router(interval_router, prefix='/interval', tags=['interval'])
frontend_router.include_router(composition_router, prefix='/composition', tags=['composition'])
frontend_router.include_router(revision_router, prefix='/revision', tags=['revision'])
frontend_router.include_router(problem_router, prefix='/problem', tags=['problem'])
frontend_router.include_router(delete_all_about_duty_router, prefix='/service/all_about_duty', tags=['service'])
frontend_router.include_router(service_router, prefix='/service', tags=['service'])
frontend_router.include_router(gap_settings_router, prefix='/settings/gap', tags=['manual_gap_settings'])
frontend_router.include_router(manual_gap_router, prefix='/manual_gaps', tags=['manual_gap'])
frontend_router.include_router(slot_router, prefix='/slot', tags=['slot'])
