from sqlalchemy.orm import Session

from watcher.db.base import dbconnect
from watcher.crud.schedule_group import query_autogenerated_groups_without_schedule
from .base import lock_task


@lock_task(save_metrics=True, send_to_unistat=True)
@dbconnect
def delete_autogenerated_groups_without_schedule(session: Session):
    schedules_groups = query_autogenerated_groups_without_schedule(session)

    for schedule in schedules_groups:
        session.delete(schedule)
